"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = __importStar(require("chai"));
const chai_as_promised_1 = __importDefault(require("chai-as-promised"));
const OpenGroupUtils_1 = require("../../../../bchat/apis/open_group_api/utils/OpenGroupUtils");
chai_1.default.use(chai_as_promised_1.default);
describe('SocialGroupUtils', () => {
    describe('prefixify', () => {
        it('should just return if http:// is as prefix', () => {
            (0, chai_1.expect)((0, OpenGroupUtils_1.prefixify)('http://plop.com')).to.be.equal('http://plop.com');
        });
        it('should just return if https:// is as prefix', () => {
            (0, chai_1.expect)((0, OpenGroupUtils_1.prefixify)('https://plop.com')).to.be.equal('https://plop.com');
        });
        it('should just return if http:// is as prefix even with hasSSL = true', () => {
            (0, chai_1.expect)((0, OpenGroupUtils_1.prefixify)('http://plop.com', true)).to.be.equal('http://plop.com');
        });
        it('should just return if https:// is as prefix even with hasSSL = true', () => {
            (0, chai_1.expect)((0, OpenGroupUtils_1.prefixify)('https://plop.com', true)).to.be.equal('https://plop.com');
        });
        it('should just return if http:// is as prefix even with hasSSL = false', () => {
            (0, chai_1.expect)((0, OpenGroupUtils_1.prefixify)('http://plop.com', false)).to.be.equal('http://plop.com');
        });
        it('should just return if https:// is as prefix even with hasSSL = false', () => {
            (0, chai_1.expect)((0, OpenGroupUtils_1.prefixify)('https://plop.com', false)).to.be.equal('https://plop.com');
        });
        it('should prefix with http if ssl is false and no prefix', () => {
            (0, chai_1.expect)((0, OpenGroupUtils_1.prefixify)('plop.com', false)).to.be.equal('http://plop.com');
        });
        it('should prefix with https if ssl is true and no prefix', () => {
            (0, chai_1.expect)((0, OpenGroupUtils_1.prefixify)('plop.com', true)).to.be.equal('https://plop.com');
        });
    });
    describe('getSocialGroupV2ConversationId', () => {
        describe('throws if roomId is not valid', () => {
            it('throws if roomId is too long 64 ', () => {
                (0, chai_1.expect)(() => {
                    (0, OpenGroupUtils_1.getOpenGroupV2ConversationId)('http://plop.com', '012345678901234567890#1234567!89012345678901234567890123456789fg01234');
                }).to.throw('getSocialGroupV2ConversationId: Invalid roomId');
            });
            it('throws if roomId is too short ', () => {
                (0, chai_1.expect)(() => {
                    (0, OpenGroupUtils_1.getOpenGroupV2ConversationId)('http://plop.com', '');
                }).to.throw('getSocialGroupV2ConversationId: Invalid roomId');
            });
            it('throws if roomId is has forbidden chars ', () => {
                (0, chai_1.expect)(() => {
                    (0, OpenGroupUtils_1.getOpenGroupV2ConversationId)('http://plop.com', '1&%^%');
                }).to.throw('getSocialGroupV2ConversationId: Invalid roomId');
            });
        });
        it('doesnt throw if roomId and serverUrl are valid ', () => {
            (0, chai_1.expect)(() => {
                (0, OpenGroupUtils_1.getOpenGroupV2ConversationId)('http://127.0.0.1/', 'plop1234');
            }).to.not.throw();
        });
        it('doesnt throw if roomId and serverUrl are valid with port', () => {
            (0, chai_1.expect)(() => {
                (0, OpenGroupUtils_1.getOpenGroupV2ConversationId)('http://127.0.0.1:22/', 'plop1234');
            }).to.not.throw();
        });
        it('doesnt throw if roomId and serverUrl are valid with port', () => {
            (0, chai_1.expect)(() => {
                (0, OpenGroupUtils_1.getOpenGroupV2ConversationId)('https://opengroup.com/', 'plop1234');
            }).to.not.throw();
        });
        it('throw if serverUrl is no url', () => {
            (0, chai_1.expect)(() => {
                (0, OpenGroupUtils_1.getOpenGroupV2ConversationId)('opengroup', 'plop1234');
            }).to.throw();
        });
    });
    describe('getCompleteUrlFromRoom', () => {
        it('doesnt throw if roomId and serverUrl are valid with port', () => {
            (0, chai_1.expect)((0, OpenGroupUtils_1.getCompleteUrlFromRoom)({
                roomId: 'plop1234',
                serverPublicKey: '05123456789',
                serverUrl: 'https://example.org',
            })).to.be.eq('https://example.org/plop1234?public_key=05123456789');
        });
        it('throws if pubkey is empty', () => {
            (0, chai_1.expect)(() => (0, OpenGroupUtils_1.getCompleteUrlFromRoom)({
                roomId: 'plop1234',
                serverPublicKey: '',
                serverUrl: 'https://example.org',
            })).to.throw('getCompleteUrlFromRoom needs serverPublicKey, roomid and serverUrl to be set');
        });
        it('throws if serverUrl is empty', () => {
            (0, chai_1.expect)(() => (0, OpenGroupUtils_1.getCompleteUrlFromRoom)({
                roomId: 'plop1234',
                serverPublicKey: '05123456789',
                serverUrl: '',
            })).to.throw('getCompleteUrlFromRoom needs serverPublicKey, roomid and serverUrl to be set');
        });
        it('throws if roomId is empty', () => {
            (0, chai_1.expect)(() => (0, OpenGroupUtils_1.getCompleteUrlFromRoom)({
                roomId: '',
                serverPublicKey: '05123456789',
                serverUrl: 'https://example.org',
            })).to.throw('getCompleteUrlFromRoom needs serverPublicKey, roomid and serverUrl to be set');
        });
        it('throws if pubkey is null', () => {
            (0, chai_1.expect)(() => (0, OpenGroupUtils_1.getCompleteUrlFromRoom)({
                roomId: 'plop1234',
                serverPublicKey: null,
                serverUrl: 'https://example.org',
            })).to.throw('getCompleteUrlFromRoom needs serverPublicKey, roomid and serverUrl to be set');
        });
        it('throws if serverUrl is null', () => {
            (0, chai_1.expect)(() => (0, OpenGroupUtils_1.getCompleteUrlFromRoom)({
                roomId: 'plop1234',
                serverPublicKey: '05123456789',
                serverUrl: null,
            })).to.throw('getCompleteUrlFromRoom needs serverPublicKey, roomid and serverUrl to be set');
        });
        it('throws if roomId is null', () => {
            (0, chai_1.expect)(() => (0, OpenGroupUtils_1.getCompleteUrlFromRoom)({
                roomId: null,
                serverPublicKey: '05123456789',
                serverUrl: 'https://example.org',
            })).to.throw('getCompleteUrlFromRoom needs serverPublicKey, roomid and serverUrl to be set');
        });
    });
});
