"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chai_1 = __importDefault(require("chai"));
const chai_as_promised_1 = __importDefault(require("chai-as-promised"));
const TaskWithTimeout_1 = require("../../../../bchat/utils/TaskWithTimeout");
chai_1.default.use(chai_as_promised_1.default);
chai_1.default.should();
const { assert } = chai_1.default;
const taskName = 'whatever';
describe('createTaskWithTimeout', () => {
    it('resolves when promise resolves', async () => {
        const task = () => Promise.resolve('hi!');
        const taskWithTimeout = (0, TaskWithTimeout_1.createTaskWithTimeout)(task, 'task_123');
        await taskWithTimeout().then((result) => {
            assert.strictEqual(result, 'hi!');
        });
    });
    it('flows error from promise back', async () => {
        const error = new Error('original');
        const task = () => Promise.reject(error);
        const taskWithTimeout = (0, TaskWithTimeout_1.createTaskWithTimeout)(task, 'task_123');
        await taskWithTimeout().catch((flowedError) => {
            assert.strictEqual(error, flowedError);
        });
    });
    it('rejects if promise takes too long (this one logs error to console)', async () => {
        let complete = false;
        const task = async () => new Promise(resolve => {
            setTimeout(() => {
                complete = true;
                resolve(null);
            }, 3000);
        });
        const taskWithTimeout = (0, TaskWithTimeout_1.createTaskWithTimeout)(task, taskName, 10);
        await taskWithTimeout().then(() => {
            throw new Error('it was not supposed to resolve!');
        }, () => {
            assert.strictEqual(complete, false);
        });
    });
    it('resolves if task returns something falsey', async () => {
        const task = () => { };
        const taskWithTimeout = (0, TaskWithTimeout_1.createTaskWithTimeout)(task, taskName);
        await taskWithTimeout();
    });
    it('resolves if task returns a non-promise', async () => {
        const task = () => 'hi!';
        const taskWithTimeout = (0, TaskWithTimeout_1.createTaskWithTimeout)(task, taskName);
        await taskWithTimeout().then((result) => {
            assert.strictEqual(result, 'hi!');
        });
    });
    it('rejects if task throws (and does not log about taking too long)', async () => {
        const error = new Error('Task is throwing!');
        const task = () => {
            throw error;
        };
        const taskWithTimeout = (0, TaskWithTimeout_1.createTaskWithTimeout)(task, taskName, 10);
        await taskWithTimeout().then(() => {
            throw new Error('Overall task should reject!');
        }, (flowedError) => {
            assert.strictEqual(flowedError, error);
        });
    });
});
