"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateEnvelopePlus = exports.generateEnvelopePlusClosedGroup = void 0;
const protobuf_1 = require("../../../protobuf");
const uuid_1 = __importDefault(require("uuid"));
function generateEnvelopePlusClosedGroup(groupId, sender) {
    const envelope = {
        senderIdentity: sender,
        receivedAt: Date.now(),
        timestamp: Date.now() - 2000,
        id: (0, uuid_1.default)(),
        type: protobuf_1.SignalService.Envelope.Type.CLOSED_GROUP_MESSAGE,
        source: groupId,
        content: new Uint8Array(),
        isBnsHolder: false,
        toJSON: () => ['fake'],
    };
    return envelope;
}
exports.generateEnvelopePlusClosedGroup = generateEnvelopePlusClosedGroup;
function generateEnvelopePlus(sender) {
    const envelope = {
        receivedAt: Date.now(),
        timestamp: Date.now() - 2000,
        id: (0, uuid_1.default)(),
        type: protobuf_1.SignalService.Envelope.Type.BCHAT_MESSAGE,
        source: sender,
        senderIdentity: sender,
        content: new Uint8Array(),
        isBnsHolder: false,
        toJSON: () => ['fake'],
    };
    return envelope;
}
exports.generateEnvelopePlus = generateEnvelopePlus;
