"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateFakeSnodes = exports.generateFakeSnodeWithEdKey = exports.generateFakeSnode = exports.generateFakePubKeys = exports.generateFakeECKeyPair = exports.generateFakePubKeyStr = exports.generateFakePubKey = void 0;
const crypto = __importStar(require("crypto"));
const lodash_1 = __importDefault(require("lodash"));
const keypairs_1 = require("../../../receiver/keypairs");
const types_1 = require("../../../bchat/types");
function generateFakePubKey() {
    const numBytes = types_1.PubKey.PUBKEY_LEN / 2 - 1;
    const hexBuffer = crypto.randomBytes(numBytes).toString('hex');
    const pubkeyString = `bd${hexBuffer}`;
    return new types_1.PubKey(pubkeyString);
}
exports.generateFakePubKey = generateFakePubKey;
function generateFakePubKeyStr() {
    const numBytes = types_1.PubKey.PUBKEY_LEN / 2 - 1;
    const hexBuffer = crypto.randomBytes(numBytes).toString('hex');
    const pubkeyString = `bd${hexBuffer}`;
    return pubkeyString;
}
exports.generateFakePubKeyStr = generateFakePubKeyStr;
function generateFakeECKeyPair() {
    const pubkey = generateFakePubKey().toArray();
    const privKey = new Uint8Array(crypto.randomBytes(64));
    return new keypairs_1.ECKeyPair(pubkey, privKey);
}
exports.generateFakeECKeyPair = generateFakeECKeyPair;
function generateFakePubKeys(amount) {
    const numPubKeys = amount > 0 ? Math.floor(amount) : 0;
    return new Array(numPubKeys).fill(0).map(() => generateFakePubKey());
}
exports.generateFakePubKeys = generateFakePubKeys;
function generateFakeSnode() {
    return {
        ip: `136.243.${Math.random() * 255}.${Math.random() * 255}`,
        port: 22116,
        pubkey_x25519: generateFakePubKeyStr(),
        pubkey_ed25519: generateFakePubKeyStr(),
    };
}
exports.generateFakeSnode = generateFakeSnode;
function generateFakeSnodeWithEdKey(ed25519Pubkey) {
    return {
        ip: `136.243.${Math.random() * 255}.${Math.random() * 255}`,
        port: 22116,
        pubkey_x25519: generateFakePubKeyStr(),
        pubkey_ed25519: ed25519Pubkey,
    };
}
exports.generateFakeSnodeWithEdKey = generateFakeSnodeWithEdKey;
function generateFakeSnodes(amount) {
    const ar = lodash_1.default.times(amount, generateFakeSnode);
    return ar;
}
exports.generateFakeSnodes = generateFakeSnodes;
