"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getName = exports.AddressType = exports.ContactType = void 0;
var ContactType;
(function (ContactType) {
    ContactType[ContactType["HOME"] = 1] = "HOME";
    ContactType[ContactType["MOBILE"] = 2] = "MOBILE";
    ContactType[ContactType["WORK"] = 3] = "WORK";
    ContactType[ContactType["CUSTOM"] = 4] = "CUSTOM";
})(ContactType = exports.ContactType || (exports.ContactType = {}));
var AddressType;
(function (AddressType) {
    AddressType[AddressType["HOME"] = 1] = "HOME";
    AddressType[AddressType["WORK"] = 2] = "WORK";
    AddressType[AddressType["CUSTOM"] = 3] = "CUSTOM";
})(AddressType = exports.AddressType || (exports.AddressType = {}));
function getName(contact) {
    const { name, organization } = contact;
    const displayName = (name && name.displayName) || undefined;
    const givenName = (name && name.givenName) || undefined;
    const familyName = (name && name.familyName) || undefined;
    const backupName = (givenName && familyName && `${givenName} ${familyName}`) || undefined;
    return displayName || organization || backupName || givenName || familyName;
}
exports.getName = getName;
