"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createLastMessageUpdate = void 0;
const createLastMessageUpdate = ({ currentTimestamp, lastMessage, lastMessageStatus, lastMessageNotificationText, }) => {
    if (!lastMessage) {
        return {
            lastMessage: '',
            lastMessageStatus: undefined,
            timestamp: undefined,
        };
    }
    const { expirationTimerUpdate } = lastMessage;
    const isExpireTimerUpdateFromSync = Boolean(expirationTimerUpdate && expirationTimerUpdate.fromSync);
    const shouldUpdateTimestamp = Boolean(!isExpireTimerUpdateFromSync);
    const newTimestamp = shouldUpdateTimestamp ? lastMessage.sent_at : currentTimestamp;
    return {
        lastMessage: lastMessageNotificationText || '',
        lastMessageStatus: lastMessageStatus || undefined,
        timestamp: newTimestamp || undefined,
    };
};
exports.createLastMessageUpdate = createLastMessageUpdate;
