"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AudioManager = void 0;
let currentlyPlayingAudio = null;
let onAudioStopped = null;
let onAudioResetWaveform = null;
exports.AudioManager = {
    setCurrent(audio, onStop, onResetWaveform) {
        if (currentlyPlayingAudio && currentlyPlayingAudio !== audio) {
            currentlyPlayingAudio.pause();
            if (onAudioStopped)
                onAudioStopped();
            if (onAudioResetWaveform)
                onAudioResetWaveform();
        }
        currentlyPlayingAudio = audio;
        onAudioStopped = onStop || null;
        onAudioResetWaveform = onResetWaveform || null;
    },
    clearCurrent(audio) {
        if (currentlyPlayingAudio === audio) {
            currentlyPlayingAudio = null;
            if (onAudioStopped)
                onAudioStopped();
            onAudioStopped = null;
            onAudioResetWaveform = null;
        }
    },
};
