"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExpirationTimerOptions = void 0;
const lodash_1 = __importDefault(require("lodash"));
const moment_1 = __importDefault(require("moment"));
const conversations_1 = require("../state/ducks/conversations");
const wallClockListener_1 = require("./wallClockListener");
const Data = __importStar(require("../data/data"));
async function destroyExpiredMessages() {
    try {
        window.log.info('destroyExpiredMessages: Loading messages...');
        const messages = await Data.getExpiredMessages();
        await Promise.all(messages.map(async (message) => {
            window.log.info('Message expired', {
                sentAt: message.get('sent_at'),
            });
            await Data.removeMessage(message.id);
            window.inboxStore?.dispatch((0, conversations_1.messageExpired)({
                conversationKey: message.attributes.conversationId,
                messageId: message.id,
            }));
            const conversation = message.getConversation();
            if (conversation) {
                await conversation.onExpired(message);
            }
        }));
    }
    catch (error) {
        window.log.error('destroyExpiredMessages: Error deleting expired messages', error && error.stack ? error.stack : error);
    }
    window.log.info('destroyExpiredMessages: complete');
    void checkExpiringMessages();
}
let timeout;
async function checkExpiringMessages() {
    const messages = await Data.getNextExpiringMessage();
    const next = messages.at(0);
    if (!next) {
        return;
    }
    const expiresAt = next.get('expires_at');
    if (!expiresAt) {
        return;
    }
    window.log.info('next message expires', new Date(expiresAt).toISOString());
    window.log.info('next message expires in ', (expiresAt - Date.now()) / 1000);
    let wait = expiresAt - Date.now();
    if (wait < 0) {
        wait = 0;
    }
    if (wait > 2147483647) {
        wait = 2147483647;
    }
    if (timeout) {
        global.clearTimeout(timeout);
    }
    timeout = global.setTimeout(destroyExpiredMessages, wait);
}
const throttledCheckExpiringMessages = lodash_1.default.throttle(checkExpiringMessages, 1000);
let isInit = false;
const initExpiringMessageListener = () => {
    if (isInit) {
        throw new Error('expiring messages listener is already init');
    }
    void checkExpiringMessages();
    (0, wallClockListener_1.initWallClockListener)(throttledCheckExpiringMessages);
    isInit = true;
};
const updateExpiringMessagesCheck = () => {
    void throttledCheckExpiringMessages();
};
function getTimerOptionName(time, unit) {
    return (window.i18n(['timerOption', time, unit].join('_')) ||
        moment_1.default.duration(time, unit).humanize());
}
function getTimerOptionAbbreviated(time, unit) {
    return window.i18n(['timerOption', time, unit, 'abbreviated'].join('_'));
}
const timerOptionsDurations = [
    { time: 0, unit: 'seconds' },
    { time: 1, unit: 'week' },
    { time: 1, unit: 'day' },
    { time: 12, unit: 'hours' },
    { time: 6, unit: 'hours' },
    { time: 1, unit: 'hour' },
    { time: 30, unit: 'minutes' },
    { time: 5, unit: 'minutes' },
    { time: 1, unit: 'minute' },
    { time: 30, unit: 'seconds' },
    { time: 10, unit: 'seconds' },
    { time: 5, unit: 'seconds' },
].map(o => {
    const duration = moment_1.default.duration(o.time, o.unit);
    return {
        time: o.time,
        unit: o.unit,
        seconds: duration.asSeconds(),
    };
});
function getName(seconds = 0) {
    const o = timerOptionsDurations.find(m => m.seconds === seconds);
    if (o) {
        return getTimerOptionName(o.time, o.unit);
    }
    return [seconds, 'seconds'].join(' ');
}
function getAbbreviated(seconds = 0) {
    const o = timerOptionsDurations.find(m => m.seconds === seconds);
    if (o) {
        return getTimerOptionAbbreviated(o.time, o.unit);
    }
    return [seconds, 's'].join('');
}
function getTimerSecondsWithName() {
    return timerOptionsDurations.map(t => {
        return { name: getName(t.seconds), value: t.seconds };
    });
}
exports.ExpirationTimerOptions = {
    getName,
    getAbbreviated,
    updateExpiringMessagesCheck,
    initExpiringMessageListener,
    getTimerSecondsWithName,
};
