"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.saveRecentReations = exports.getRecentReactions = exports.Storage = exports.saveRecoveryPhrase = exports.getCurrentRecoveryPhrase = exports.setLastProfileUpdateTimestamp = exports.getLastProfileUpdateTimestamp = exports.setSignWithRecoveryPhrase = exports.isSignWithRecoveryPhrase = exports.setSignInByLinking = exports.isSignInByLinking = exports.getNumber = exports.setLocalPubKey = void 0;
const channelsItem_1 = require("../data/channelsItem");
const constants_1 = require("../bchat/constants");
let ready = false;
let items;
let callbacks = [];
reset();
async function put(key, value) {
    if (value === undefined) {
        throw new Error('Tried to store undefined');
    }
    if (!ready) {
        window.log.warn('Called storage.put before storage is ready. key:', key);
    }
    const data = { id: key, value };
    items[key] = data;
    await (0, channelsItem_1.createOrUpdateItem)(data);
}
function get(key, defaultValue) {
    if (!ready) {
        window.log.warn('Called storage.get before storage is ready. key:', key);
    }
    const item = items[key];
    if (!item) {
        return defaultValue;
    }
    return item.value;
}
async function remove(key) {
    if (!ready) {
        window.log.warn('Called storage.get before storage is ready. key:', key);
    }
    delete items[key];
    await (0, channelsItem_1.removeItemById)(key);
}
function onready(callback) {
    if (ready) {
        callback();
    }
    else {
        callbacks.push(callback);
    }
}
function callListeners() {
    if (ready) {
        callbacks.forEach(callback => {
            callback();
        });
        callbacks = [];
    }
}
async function fetch() {
    reset();
    const array = await (0, channelsItem_1.getAllItems)();
    for (let i = 0, max = array.length; i < max; i += 1) {
        const item = array[i];
        const { id } = item;
        items[id] = item;
    }
    ready = true;
    callListeners();
}
function reset() {
    ready = false;
    items = Object.create(null);
}
async function setLocalPubKey(pubkey) {
    await put('number_id', `${pubkey}.1`);
}
exports.setLocalPubKey = setLocalPubKey;
function getNumber() {
    const numberId = get('number_id');
    if (numberId === undefined) {
        return undefined;
    }
    return numberId.split('.')[0];
}
exports.getNumber = getNumber;
function isSignInByLinking() {
    const isByLinking = get('is_sign_in_by_linking');
    if (isByLinking === undefined) {
        return false;
    }
    return isByLinking;
}
exports.isSignInByLinking = isSignInByLinking;
async function setSignInByLinking(isLinking) {
    await put('is_sign_in_by_linking', isLinking);
}
exports.setSignInByLinking = setSignInByLinking;
function isSignWithRecoveryPhrase() {
    const isRecoveryPhraseUsed = get('is_sign_in_recovery_phrase');
    if (isRecoveryPhraseUsed === undefined) {
        return false;
    }
    return isRecoveryPhraseUsed;
}
exports.isSignWithRecoveryPhrase = isSignWithRecoveryPhrase;
async function setSignWithRecoveryPhrase(isRecoveryPhraseUsed) {
    await put('is_sign_in_recovery_phrase', isRecoveryPhraseUsed);
}
exports.setSignWithRecoveryPhrase = setSignWithRecoveryPhrase;
function getLastProfileUpdateTimestamp() {
    return get('last_profile_update_timestamp');
}
exports.getLastProfileUpdateTimestamp = getLastProfileUpdateTimestamp;
async function setLastProfileUpdateTimestamp(lastUpdateTimestamp) {
    await put('last_profile_update_timestamp', lastUpdateTimestamp);
}
exports.setLastProfileUpdateTimestamp = setLastProfileUpdateTimestamp;
function getCurrentRecoveryPhrase() {
    return exports.Storage.get('mnemonic');
}
exports.getCurrentRecoveryPhrase = getCurrentRecoveryPhrase;
async function saveRecoveryPhrase(mnemonic) {
    return exports.Storage.put('mnemonic', mnemonic);
}
exports.saveRecoveryPhrase = saveRecoveryPhrase;
exports.Storage = { fetch, put, get, remove, onready, reset };
function getRecentReactions() {
    const reactions = exports.Storage.get('recent_reactions');
    if (reactions) {
        return reactions.split(' ');
    }
    else {
        return constants_1.DEFAULT_RECENT_REACTS;
    }
}
exports.getRecentReactions = getRecentReactions;
async function saveRecentReations(reactions) {
    return exports.Storage.put('recent_reactions', reactions.join(' '));
}
exports.saveRecentReations = saveRecentReations;
