"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.loadFiatCurrency = exports.loadRecipient = exports.deamonvalidation = exports.workingStatusForDeamon = void 0;
const request_promise_1 = __importDefault(require("request-promise"));
const settings_key_1 = require("../data/settings-key");
const utils_1 = require("../bchat/utils");
async function workingStatusForDeamon(currentdeamon, type) {
    try {
        const options = {
            uri: `http://${currentdeamon.host}:${currentdeamon.port}/json_rpc`,
            method: 'POST',
            json: {
                jsonrpc: '2.0',
                id: '0',
                method: 'getinfo',
            },
            timeout: 0,
        };
        let requestData = await (0, request_promise_1.default)(options);
        if (requestData.result) {
            return requestData.result;
        }
    }
    catch (err) {
        if (window.globalOnlineStatus && !type) {
            utils_1.ToastUtils.pushToastError('daemonRpcDown', 'Your current daemon down.Please choose another daemon from settings.');
        }
        return { status: 'NOT_OK', host: currentdeamon.host, port: currentdeamon.port };
    }
}
exports.workingStatusForDeamon = workingStatusForDeamon;
async function deamonvalidation() {
    let list_deamon = window.getSettingValue(settings_key_1.walletSettingsKey.settingsDeamonList);
    let getcurrentWorkingDeamon = window.getSettingValue('current-deamon');
    const currentDaemon = getcurrentWorkingDeamon
        ? getcurrentWorkingDeamon
        : window.currentDaemon;
    if (!list_deamon) {
        const deamon_list = window.deamon_list;
        window.setSettingValue('deamon-List', deamon_list);
    }
    const deamonStatus = await workingStatusForDeamon(currentDaemon);
    if (deamonStatus.status === 'OK') {
        window.setSettingValue('current-deamon', currentDaemon);
    }
    else {
        for (let index = 0; index < list_deamon.length; index++) {
            const deamonStatus = await workingStatusForDeamon(list_deamon[index]);
            if (deamonStatus.status === 'OK') {
                window.setSettingValue('current-deamon', currentDaemon);
                break;
            }
        }
    }
}
exports.deamonvalidation = deamonvalidation;
function loadRecipient() {
    if (!window.getSettingValue('save-recipient')) {
        window.setSettingValue('save-recipient', true);
    }
}
exports.loadRecipient = loadRecipient;
function loadFiatCurrency() {
    if (!window.getSettingValue('fiat-currency')) {
        window.setSettingValue('fiat-currency', 'USD');
    }
}
exports.loadFiatCurrency = loadFiatCurrency;
